﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ParkingManager
{
    internal class FileControl
    {
        string basePath = "c:\\carsA";
        string baseFile = "list.txt"; //현재 주차 정보 저장
        string oldFile = "oldlist.txt";//과거 주차 정보 저장

        bool ExistBasePath()
        {
            if (false == Directory.Exists(basePath)) {
                if(null == Directory.CreateDirectory(basePath)) {
                    return false;
                }
            }

            return true;
        }

        public void WriteCurrentInfo(Car[] cars)
        {
            if (ExistBasePath()) {
                try {
                    var fullname = Path.Combine(basePath ,baseFile);

                    //쓰기: 새로만들기(Create) or 추가하기(Append)
                    var fs = new FileStream(fullname, FileMode.Create);
                    var sw = new StreamWriter(fs, Encoding.UTF8);

                    //현재 주차 정보 내용을 파일에 출력(쓰기)
                    for(int i=0; i < cars.Length; i++) {
                        if (cars[i] != null) {
                            var lotno = i.ToString();
                            var carnum = cars[i].CarNumber;
                            var intime = cars[i].InTime.ToString("yyyyMMdd HHmmss");

                            var result = $"{lotno}|{carnum}|{intime}";

                            sw.WriteLine(result);
                        }
                    }

                    sw.Close();
                    fs.Close();
                }catch(Exception ex) {
                    MessageBox.Show(ex.ToString());
                }
            }
        }

        public void ReadCurrentInfo(Car[] cars)
        {
            if (ExistBasePath()) {
                try {
                    var fullname = Path.Combine(basePath, baseFile);

                    if (File.Exists(fullname)) {
                        var fs = new FileStream(fullname, FileMode.Open);
                        var sr = new StreamReader(fs, Encoding.UTF8);

                        while (false == sr.EndOfStream) {

                            //line = "0|1111|20230531 122115";
                            var line = sr.ReadLine();

                            if (string.IsNullOrEmpty(line)) {
                                continue;
                            }
                            //splitlines = {"0","1111","20230531 122115" }
                            var splitlines = line.Split(new char[] { '|'});
                            if(splitlines.Length == 3) {
                                if (int.TryParse(splitlines[0], out int lotno)) {
                                    string num = splitlines[1].Trim();

                                    if (DateTime.TryParseExact(
                                        splitlines[2]
                                        , "yyyyMMdd HHmmss"
                                        , null
                                        , System.Globalization.DateTimeStyles.None
                                        , out DateTime intime)) {
                                        cars[lotno] = new Car(num, intime);
                                    }
                                }
                            }
                        }

                        sr.Close();
                        fs.Close();
                    }

                }catch(Exception ex) {
                    MessageBox.Show(ex.ToString());
                }
            }
        }

        internal void ReadHistoryInfo(List<Car> carsHistroy)
        {
            //basePath\\oldFile
            //파일이 있는 경우에만 읽어오기
            //자동차번호 입차시간 출차시간

            if (ExistBasePath()) {
                try {
                    var fullname = Path.Combine(basePath, oldFile);

                    if (File.Exists(fullname)) {
                        var fs = new FileStream(fullname, FileMode.Open);
                        var sr = new StreamReader(fs, Encoding.UTF8);

                        while (false == sr.EndOfStream) {
                            //var line = "1111|20230531 121212|20230531 121212";
                            var line = sr.ReadLine();

                            if (string.IsNullOrEmpty(line)) {
                                continue;
                            }

                            var splitlines = line.Split(new char[] { '|' });
                            if (splitlines.Length == 3) {
                                string num = splitlines[0].Trim();

                                var result1 = DateTime.TryParseExact(
                                    splitlines[1]
                                    , "yyyyMMdd HHmmss"
                                    , null
                                    , System.Globalization.DateTimeStyles.None
                                    , out DateTime intime);

                                var result2 = DateTime.TryParseExact(
                                    splitlines[2]
                                    , "yyyyMMdd HHmmss"
                                    , null
                                    , System.Globalization.DateTimeStyles.None
                                    , out DateTime outtime);

                                if (true == result1 && true == result2) {
                                    carsHistroy.Add(new Car(num, intime, outtime));
                                }
                            }
                        }

                        sr.Close();
                        fs.Close();
                    }

                } catch (Exception ex) {
                    MessageBox.Show(ex.ToString());
                }
            }
        }
    }
}
